// CreateALTZ.cpp : implementation file
//

#include "stdafx.h"
#include "db_apivcclient.h"
#include "CreateALTZ.h"
#include <afxtempl.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCreateALTZ dialog


CCreateALTZ::CCreateALTZ(CWnd* pParent /*=NULL*/)
	: CDialog(CCreateALTZ::IDD, pParent)
{
	//{{AFX_DATA_INIT(CCreateALTZ)
	m_sDesc = _T("");
	m_sName = _T("");
	//}}AFX_DATA_INIT
}

CCreateALTZ ::CCreateALTZ(IApplication *pApp):CDialog(CCreateALTZ::IDD, NULL)
{
	m_iToBe = 0;
	pApplication = pApp;//	pTZ.CreateInstance(__uuidof(TimeZone));
}


void CCreateALTZ::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCreateALTZ)
	DDX_Control(pDX, IDC_ACCTLIST, m_AcctList);
	DDX_Control(pDX, IDC_SUBACCTLIST, m_SubAcctList);
	DDX_Radio(pDX, IDC_RADIO_AL, m_iToBe);
	DDX_Text(pDX, IDC_EDIT_DESC, m_sDesc);
	DDX_Text(pDX, IDC_EDIT_NAME, m_sName);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CCreateALTZ, CDialog)
	//{{AFX_MSG_MAP(CCreateALTZ)
	ON_BN_CLICKED(IDC_BTN_CREATE, OnBtnCreate)
	ON_CBN_SELCHANGE(IDC_ACCTLIST, OnSelchangeAcctlist)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCreateALTZ message handlers

void CCreateALTZ::OnBtnCreate() 
{
	UpdateData(TRUE);	

	CArray<int,int> Acctsels;
	VARIANT vAccounts;
	int nAcct = 1;
	COleSafeArray saAccounts;
	saAccounts.CreateOneDim(VT_I4,nAcct);
	Acctsels.SetSize(nAcct);
	for(long i = 0; i < nAcct; i++)                                                  
	{                                                      
		CString sAcctID;       
		long acct_index = m_AcctList.GetCurSel();
		m_AcctList.GetLBText(acct_index,sAcctID);
		long lAcctID = _wtol(sAcctID);
		saAccounts.PutElement(&i,&lAcctID);
	}
	vAccounts = saAccounts.Detach();

	CArray<int,int> SubAcctsels;
	VARIANT vSubAccounts;
	int nSubAcct = m_SubAcctList.GetSelCount();
	COleSafeArray saSubAccounts;
	saSubAccounts.CreateOneDim(VT_I4,nSubAcct);
	SubAcctsels.SetSize(nSubAcct);
	m_SubAcctList.GetSelItems(nSubAcct, SubAcctsels.GetData());
	for(long j = 0; j < nSubAcct; j++)                                                  
	{                                                      
		CString sSubAcctID;       
		long lSubAcctID = 0;
		m_SubAcctList.GetText(SubAcctsels[j], sSubAcctID);
		lSubAcctID = _wtoi(sSubAcctID);
		saSubAccounts.PutElement(&j,&lSubAcctID);
	}
	vSubAccounts = saSubAccounts.Detach();

	BSTR bstrName, bstrDesc;
	bstrName = m_sName.AllocSysString();
	bstrDesc = m_sDesc.AllocSysString();

	//select account name 
	int acct_index = m_AcctList.GetCurSel();
	CString sAcctID;
	m_AcctList.GetLBText(acct_index,sAcctID);
	long lAccountID = _wtol(sAcctID);
	BSTR bstrAcctName;
	pApplication->GetAccountNameByAcctID(lAccountID,&bstrAcctName);
	
	// To Create AL
	if(m_iToBe == 0)
	{
		long lStatus = 1;
		pApplication->CreateAccessLevel(bstrName, bstrDesc, vSubAccounts,bstrAcctName, &lStatus);

		if (lStatus == 105)
		{
			AfxMessageBox(L"InValid SubAccount name");
			return;
		}
		if(lStatus == 201)
		{
			AfxMessageBox(L"InValid Access level name");
			return;
		}
		if (lStatus == 206)
		{
			AfxMessageBox(L"Invalid Accesslevel Name / Description string length");
			return;
		}
		if ( lStatus == 202)
		{
			AfxMessageBox(L"AccessLevel Name Exists");
			return;
		}
		if (lStatus == 1)
		{
			AfxMessageBox(L"AccessLevel Addition Failed");
			return;
		}
		else
		{
			AfxMessageBox(L"Access level Addition succeded");
			CDialog::OnOK();
		}
		return;
	}
	// To Create TZ
	else
	{
		long lStatus = 1;
		pApplication->CreateTimezone(bstrName, bstrDesc, vAccounts, &lStatus);
		::SysFreeString(bstrName);
		::SysFreeString(bstrDesc);
		if (lStatus == 105)
		{
			AfxMessageBox(L"InValid Account name");
			return;
		}
		if(lStatus == 601)
		{
			AfxMessageBox(L"InValid Time Zone name");
			return;
		}
		if (lStatus == 603)
		{
			AfxMessageBox(L"Invalid Time Zone Name / Description string length");
			return;
		}
		if ( lStatus == 602)
		{
			AfxMessageBox(L"Time Zone Name Exists");
			return;
		}
		if (lStatus == 1)
		{
			AfxMessageBox(L"Time Zone Addition Failed");
			return;
		}
		else
		{
			AfxMessageBox(L"Time Zone Addition succeeded");
			CDialog::OnOK();
		}
	}
	
}

BOOL CCreateALTZ::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	LoadAccounts();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}


void CCreateALTZ::LoadAccounts()
{
	_variant_t vAccounts;
	vAccounts.Clear();
	pApplication->GetAccounts(&vAccounts); // get account details in WP-CS database server
	
	if(vAccounts.vt ==  VT_EMPTY)
	{
		return;
	}
	
	long uBound =0 ;
	IAccount *pAccount = NULL;
	
	COleSafeArray sa(vAccounts);
	sa.GetUBound(1,&uBound);
	UpdateData(TRUE);
	for(long i =0 ;i <= uBound ; i++)
		
	{
		IDispatch *pDisp = NULL;
		sa.GetElement(&i,(void*)&pDisp);
		HRESULT hr = pDisp->QueryInterface(IID_IAccount,(void**)&pAccount);
		if (pAccount != NULL)
		{
			CString sAcctID;
			sAcctID.Format(L"%ld",pAccount->AccountID); 
			m_AcctList.AddString(sAcctID);
			pAccount->Release();
		}
		pDisp->Release();
	}
	UpdateData(FALSE);
}

void CCreateALTZ::LoadSubAccounts(long lAcctID)
{
	_variant_t vSubAccounts;
	vSubAccounts.Clear();
	pApplication->GetSubAccountsByAccountID(lAcctID,&vSubAccounts); // get subaccount details in WP-CS database server
	
	if(vSubAccounts.vt ==  VT_EMPTY)
	{
		return;
	}
	
	long uBound =0 ;
	IAccount *pSubAccount = NULL;
	
	COleSafeArray sa(vSubAccounts);
	sa.GetUBound(1,&uBound);
	UpdateData(TRUE);
	for(long i =0 ;i <= uBound ; i++)
		
	{
		IDispatch *pDisp = NULL;
		sa.GetElement(&i,(void*)&pDisp);
		HRESULT hr = pDisp->QueryInterface(IID_IAccount,(void**)&pSubAccount);
		if (pSubAccount != NULL)
		{
			CString sSubAcctID;
			sSubAcctID.Format(L"%ld",pSubAccount->AccountID); 
			m_SubAcctList.AddString(sSubAcctID);
			pSubAccount->Release();
		}
		pDisp->Release();
	}
	UpdateData(FALSE);
}

void CCreateALTZ::OnSelchangeAcctlist()
{
	int index_Acct = m_AcctList.GetCurSel();
	CString sAcctid;

	m_AcctList.GetLBText(index_Acct,sAcctid);
	long lAccountID = _wtoi(sAcctid);

	m_SubAcctList.ResetContent();
	LoadSubAccounts(lAccountID);
}